### BUILD LINUX Library (static or dynamic) ###
#!/bin/bash

# Don't include the current LIBPATH in the loader section of module generated
export LIBPATH=/usr/lib:/lib
export DLL_VER=0
export FULL_VER=0.0.0

if test "$1" = "d"
then
	COMPILE_MODE="debug"
fi

if test "$1" = "r"
then
	COMPILE_MODE="release"
fi

if test "$LINK_MODE" = ""
then
	if test "$COMPILE_MODE" = ""
	then
		echo "build [d|r] [clean]"
		return 1
	fi
fi

#######################################

export sysconfdir=/etc
VER_COMMON="-D UNIX_LUX"
if test $COMPILE_MODE = "debug"
then
	export DEBUG="-g -D _DEBUG" 
	export RELEASE=
	export VER="${DEBUG} ${VER_COMMON}"
	export REPVER="debug"
	export REPVER_LIBS="debug"
else
	export DEBUG=
	export RELEASE=
	export VER="${RELEASE} -O2  ${VER_COMMON}"
	export REPVER="release"
	export REPVER_LIBS="release"
fi

export REPVER_OPENSSL=${REPVER_LIBS}

# Dynamic link
export REPVER=${REPVER}
export REPVER_LIBS=${REPVER_LIBS}
export CFLAGS="-fPIC ${VER} -c -Wall"
export CFLAGS_TST="-c -Wall ${VER}"
export LDFLAGS="-Bsymbolic -shared -Wl ${VER}"
export LDFLAGS_TST="${VER}"

PROJ=pgm_exemple_jni_lux

dos2unix ${PROJ}.mak

if test "$2" = "clean"
then
  make -f ${PROJ}.mak cleanup
fi

# make -f ${PROJ}.mak ${LINK_MODE}
DATE=`date`
echo "*******************************************************************************" > ${REPVER}/build.lst
echo "${PROJ} ${REPVER} ${LINK_MODE}          ${DATE}" >> ${REPVER}/build.lst
echo "-------------------------------------------------------------------------------" >> ${REPVER}/build.lst
echo "*******************************************************************************" > ${REPVER}/build.err
echo "${PROJ} ${REPVER} ${LINK_MODE}          ${DATE}" >> ${REPVER}/build.err
echo "-------------------------------------------------------------------------------" >> ${REPVER}/build.err
make -f ./${PROJ}.mak ${LINK_MODE} 2>>${REPVER}/build.err
if test $? = 0
then
	echo "\b"
	echo "OK    (Verify also: ${REPVER}/build.err)"
	echo "OK    (Verify also: ${REPVER}/build.err)" >> ${REPVER}/build.lst
else
	echo "ERROR (See: ${REPVER}/build.err)"
	echo "ERROR (See: ${REPVER}/build.err)"  >> ${REPVER}/build.lst
fi
echo "*******************************************************************************" >> ${REPVER}/build.lst
echo "*******************************************************************************" >> ${REPVER}/build.err

